/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.AbstractPositionSequenceBuilder;
import org.geolatte.geom.PackedPositionSequence;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionFactory;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.Positions;

class FixedSizePositionSequenceBuilder<P extends Position>
extends AbstractPositionSequenceBuilder<P> {
    private int index = 0;
    private final double[] coordinates;

    FixedSizePositionSequenceBuilder(int capacity, PositionFactory<P> factory) {
        super(factory);
        this.coordinates = new double[capacity * factory.getCoordinateDimension()];
    }

    FixedSizePositionSequenceBuilder(int capacity, Class<P> clazz) {
        this(capacity, Positions.getFactoryFor(clazz));
    }

    @Override
    protected void addCoordinate(double x) {
        this.coordinates[this.index++] = x;
    }

    @Override
    public PositionSequence<P> toPositionSequence() {
        if (this.index != this.coordinates.length) {
            throw new IllegalStateException("PointSequence not filled to capacity. Index at " + this.index + " and not at " + this.coordinates.length);
        }
        return new PackedPositionSequence(this.factory, this.coordinates);
    }
}

