/**
 * Classe che inizializza le funzioni
 */
import  { createMap } from './map.js';
import  { layerAreeVerdiCatanzaroComune } from './map.js';
import 	{ layerAreeVerdiCasalecchioComune } from './map.js';
import 	{ layerAreeVerdiOpenStreetMap } from './map.js';
import 	{ layerIngressi } from './map.js';
import 	{ addPolygonPopup } from './feature.js';

const map = createMap();

map.addLayer(layerAreeVerdiCatanzaroComune);
map.addLayer(layerAreeVerdiCasalecchioComune);
map.addLayer(layerAreeVerdiOpenStreetMap);
map.addLayer(layerIngressi);

const layerSwitcher = new ol.control.LayerSwitcher({
  show_progress: true,
  extent: true,
  trash: true,
  reorder: true
});

map.addControl(layerSwitcher);

addPolygonPopup(map);

