/**
 * Classe che definisce tutte le funzionalità di interazione con la mappa
 */

export function addPolygonPopup(map) {


	const select = new ol.interaction.Select({
		condition: ol.events.condition.singleClick,
	});

	map.addInteraction(select);

	const popup = new ol.Overlay.PopupFeature({
		popupClass: 'default anim',
		positioning: 'auto',
		autoPan: true,
		offset: [0, -20],
		select: select,
		template: {
			title: function(f) {
				return "Dettaglio";
			},
			attributes:
			{
				'nome': {
					title: 'Nome',
					visible: function(f) {
						return f.get('nome') !== null;
					}
				},
				'densita_alberi': {
					title: 'Densità alberi',
					visible: function(f) {
						return f.get('densita_alberi') !== null;
					}
				},
				'ubicazione': {
					title: 'Ubicazione',
					visible: function(f) {
						return f.get('ubicazione') !== null;
					}
				},
				'area': {
					title: 'Area',
					format: ol.Overlay.PopupFeature.localString(),
					after: ` m<sup>2</sup>`,
					visible: function(f) {
						return f.get('area') !== null;
					}
				},
				'comune': {
					title: 'Comune',
					visible: function(f) {
						return f.get('comune') !== null;
					}
				},
				'fonte_dati': {
					title: 'Fonte dati',
					visible: function(f) {
						return f.get('fonte_dati') !== null;
					}
				},
				'id_ingresso': {
					title: 'Id',
					visible: function(f) {
						return f.get('id_ingresso') !== null;
					}
				},
				'id_area_verde': {
					title: 'Id area verde',
					visible: function(f) {
						return f.get('id_area_verde') !== null;
					}
				},
				'area_verde': {
					title: 'Id poligono area verde',
					visible: function(f) {
						return f.get('area_verde') !== null;
					}
				},
				'id_area_blu': {
					title: 'Id area blu',
					visible: function(f) {
						return f.get('id_area_blu') !== null;
					}
				},
			}
		}
	});

	map.addOverlay(popup);
}
