/**
 * Classe che definisce la mappa principale
 */
import Map from './lib/ol/Map.js';
import View from './lib/ol/View.js';
import TileLayer from './lib/ol/layer/Tile.js';
import OSM from './lib/ol/source/OSM.js';
import {fromLonLat} from './lib/ol/proj.js';

export function createMap() {
	return new Map({
		layers: [
			new TileLayer({
				source: new OSM(),
			}),
		],
		target: 'map',
		view: new View({
			center: fromLonLat([12.4964, 41.9028]), // Coordinate di Roma
			zoom: 6,
		}),
	});
}