/**
 * Classe che definisce la mappa principale
 */
const key = 'yu9dNHW3LWkQvjqVbnXn';

export function createMap() {
	return new ol.Map({
		layers: [
			new ol.layer.Tile({
				source: new ol.source.ImageTile({
					url: 'https://api.maptiler.com/maps/satellite/{z}/{x}/{y}.jpg?key=' + key,
					tileSize: 512,
					maxZoom: 20,
				}),
				title: 'Satellite',
			}),
			new ol.layer.Tile({
				source: new ol.source.OSM(),
				title: 'Openstreetmap',
			}),
		],
		target: 'map',
		view: new ol.View({
			center: ol.proj.fromLonLat([12.4964, 41.9028]), // Coordinate di Roma
			zoom: 6
		}),
	});
}

export const layerAreeVerdiCatanzaroComune = new ol.layer.Vector({
	title: 'Aree Verdi Catanzaro',
	visible: true,
	source: new ol.source.Vector({
		format: new ol.format.GeoJSON(),
		url: function(extent) {
			return `http://localhost:8080/geoserver/Progetto_VeBS/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=Progetto_VeBS:aree_verdi_catanzaro_comune&outputFormat=application/json&srsname=EPSG:3857&bbox=${extent.join(',')},EPSG:3857`;
		},
		strategy: ol.loadingstrategy.bbox
	}),
	style: new ol.style.Style({
		stroke: new ol.style.Stroke({
			color: 'blue',
			width: 2
		}),
		fill: new ol.style.Fill({
			color: 'rgba(0, 0, 255, 0.1)'
		})
	})
});

export const layerAreeVerdiCasalecchioComune = new ol.layer.Vector({
	title: 'Aree Verdi Casalecchio di Reno',
	visible: true,
	source: new ol.source.Vector({
		format: new ol.format.GeoJSON(),
		url: function(extent) {
			return `http://localhost:8080/geoserver/Progetto_VeBS/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=Progetto_VeBS:aree_verdi_casalecchio_comune&outputFormat=application/json&srsname=EPSG:3857&bbox=${extent.join(',')},EPSG:3857`;
		},
		strategy: ol.loadingstrategy.bbox
	}),
	style: new ol.style.Style({
		stroke: new ol.style.Stroke({
			color: 'blue',
			width: 2
		}),
		fill: new ol.style.Fill({
			color: 'rgba(0, 0, 255, 0.1)'
		})
	})
});

export const layerAreeVerdiOpenStreetMap = new ol.layer.Vector({
	title: 'Aree Verdi OpenStreetMap',
	visible: true,
	source: new ol.source.Vector({
		format: new ol.format.GeoJSON(),
		url: function(extent) {
			return `http://localhost:8080/geoserver/Progetto_VeBS/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=Progetto_VeBS:aree_verdi_osm&outputFormat=application/json&srsname=EPSG:3857&bbox=${extent.join(',')},EPSG:3857`;
		},
		strategy: ol.loadingstrategy.bbox
	}),
	style: new ol.style.Style({
		stroke: new ol.style.Stroke({
			color: 'green',
			width: 2
		}),
		fill: new ol.style.Fill({
			color: 'rgba(0, 0, 255, 0.1)'
		})
	})
});

export const layerIngressi= new ol.layer.Vector({
	title: 'Ingressi',
	visible: true,
	source: new ol.source.Vector({
		format: new ol.format.GeoJSON(),
		url: function(extent) {
			return `http://localhost:8080/geoserver/Progetto_VeBS/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=Progetto_VeBS:ingresso&outputFormat=application/json&srsname=EPSG:3857&bbox=${extent.join(',')},EPSG:3857`;
		},
		strategy: ol.loadingstrategy.bbox
	}),
	style: new ol.style.Style({
	  image: new ol.style.Circle({
	    radius: 4,
	    fill: new ol.style.Fill({ color: 'red' }),
	    stroke: new ol.style.Stroke({ color: 'white', width: 1 })
	  })
	})
});

