package com.progetto.VEBS.service;

import java.util.List;
import java.util.stream.Collectors;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Service;

import com.progetto.VEBS.mapper.IngressoMapper;
import com.progetto.VEBS.model.dto.IngressoDTO;
import com.progetto.VEBS.model.entity.Ingresso;
import com.progetto.VEBS.model.repository.IngressoRepository;

@Service
public class IngressoService {

	@Autowired
	private IngressoMapper mapper;
	
	@Autowired
	private IngressoRepository ingressoRepository;

	public List<IngressoDTO> getAllIngressi() {
	    return ingressoRepository.findAll().stream()
	        .map(mapper::toDTO)
	        .collect(Collectors.toList());
	}

	public IngressoDTO getIngressoById(Integer id) {
	    return ingressoRepository.findById(id).map(mapper::toDTO)
	            .orElse(null);
	}

	public void saveIngresso(IngressoDTO ingresso_area_verde) {
		ingressoRepository.save(mapper.toEntity(ingresso_area_verde));	
	}

	public Ingresso deleteIngressoById(Integer id) throws ResourceNotFoundException {
		Ingresso ingresso = ingressoRepository.findById(id).orElseThrow(() -> new ResourceNotFoundException("Record non trovato")); 
		ingressoRepository.deleteById(id);
		return ingresso;
	}

	public void update(IngressoDTO ingresso_dto) throws ResourceNotFoundException {

		Ingresso ingresso = ingressoRepository.findById(ingresso_dto.getId()).orElseThrow(() -> new ResourceNotFoundException("Record non trovato")); 
		
		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(ingresso_dto.getWKTGeometry());
			ingresso.setGeometry(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		ingresso.setId(ingresso_dto.getId());
		ingresso.setNome(ingresso_dto.getNome());
		ingresso.setAreaVerde(ingresso_dto.getAreaVerde());
		ingresso.setAreaBlu(ingresso_dto.getAreaBlu());

		ingressoRepository.saveAndFlush(ingresso);
	}
}
