package com.progetto.VEBS.service;

import java.util.List;
import java.util.stream.Collectors;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Service;

import com.progetto.VEBS.mapper.IncidenzaArboreaMapper;
import com.progetto.VEBS.model.dto.IncidenzaArboreaDTO;
import com.progetto.VEBS.model.entity.AreaVerde;
import com.progetto.VEBS.model.entity.IncidenzaArborea;
import com.progetto.VEBS.model.repository.IncidenzaArboreaRepository;

@Service
public class IncidenzaArboreaService {
	
	@Autowired
	private IncidenzaArboreaMapper mapper;
	
	@Autowired
	private IncidenzaArboreaRepository incidenzaArboreaRepository;

	public List<IncidenzaArboreaDTO> getAllIncidenzeArboree() {
	    return incidenzaArboreaRepository.findAll().stream()
	        .map(mapper::toDTO)
	        .collect(Collectors.toList());
	}

	public IncidenzaArboreaDTO getIncidenzaArboreaById(Integer id) {
	    return incidenzaArboreaRepository.findById(id).map(mapper::toDTO)
	            .orElse(null);
	}

	public void saveIncidenzaArborea(IncidenzaArboreaDTO incidenza_arborea) {
	    incidenzaArboreaRepository.save(mapper.toEntity(incidenza_arborea));
	}

	public void deleteIncidenzaArboreaById(Integer id) throws ResourceNotFoundException {
		incidenzaArboreaRepository.findById(id).orElseThrow(() -> new ResourceNotFoundException("Record non trovato"));
		incidenzaArboreaRepository.deleteById(id);
	}

	public void updateIncidenzaArborea(IncidenzaArboreaDTO incidenza_arborea_dto) throws ResourceNotFoundException {
		IncidenzaArborea incidenza_arborea = incidenzaArboreaRepository.findById(incidenza_arborea_dto.getId()).orElseThrow(() -> new ResourceNotFoundException("Record non trovato"));

		incidenza_arborea.setId(incidenza_arborea_dto.getId());
		incidenza_arborea.setDataRilevazione(incidenza_arborea_dto.getDataRilevazione());
		incidenza_arborea.setPercentuale(incidenza_arborea_dto.getPercentuale());

		incidenzaArboreaRepository.saveAndFlush(incidenza_arborea);
	}
}
