package com.progetto.VEBS.service;

import java.util.List;
import java.util.stream.Collectors;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Service;

import com.progetto.VEBS.mapper.AreaVerdeMapper;
import com.progetto.VEBS.model.dto.AreaBluDTO;
import com.progetto.VEBS.model.dto.AreaVerdeDTO;
import com.progetto.VEBS.model.entity.AreaBlu;
import com.progetto.VEBS.model.entity.AreaVerde;
import com.progetto.VEBS.model.repository.AreaVerdeRepository;

@Service
public class AreaVerdeService {
	
	@Autowired
	private AreaVerdeMapper mapper;
	
	@Autowired
	private AreaVerdeRepository areaVerdeRepository;

	public List<AreaVerdeDTO> getAllAreeVerdi() {
	    return areaVerdeRepository.findAll().stream()
	        .map(mapper::toDTO)
	        .collect(Collectors.toList());
	}

	public AreaVerdeDTO getAreaVerdeById(Integer id) {
	    return areaVerdeRepository.findById(id).map(mapper::toDTO)
	            .orElse(null);
	}

	public void saveAreaVerde(AreaVerdeDTO areaverde) {
	    areaVerdeRepository.save(mapper.toEntity(areaverde));
	}

	public void deleteAreaVerdeById(Integer id) throws ResourceNotFoundException {
		areaVerdeRepository.findById(id).orElseThrow(() -> new ResourceNotFoundException("Record non trovato"));
		areaVerdeRepository.deleteById(id);
	}

	public void updateAreaVerde(AreaVerdeDTO areaverdeDTO) throws ResourceNotFoundException {
		AreaVerde areaverde = areaVerdeRepository.findById(areaverdeDTO.getId()).orElseThrow(() -> new ResourceNotFoundException("Record non trovato"));

		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(areaverdeDTO.getWKTGeometry());
			areaverde.setGeometry(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		areaverde.setId(areaverdeDTO.getId());
		areaverde.setNome(areaverdeDTO.getNome());
		areaverde.setDensita(areaverdeDTO.getDensita());
		areaverde.setArea(areaverdeDTO.getArea());
		areaverde.setPoligonoAreaVerde(areaverdeDTO.getPoligonoAreaVerde());

		areaVerdeRepository.saveAndFlush(areaverde);
	}
}
