package com.progetto.VEBS.model.entity;

import java.sql.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.locationtech.jts.geom.Geometry;

@Entity
@Table(name = "poligono_popolazione")
public class PoligonoPopolazione {
	
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id_poligono;

    @Column(name = "data_valutazione")
    private Date data_valutazione;

    @Column(name = "densita_per_fascia")
    private Integer densita_per_fascia;
    
    @Column(name = "n_popolazione")
    private Integer n_popolazione;

    @Column(name = "geometria", columnDefinition = "geometry(Polygon, 3857)")
    private Geometry geometria;

    @Column(name = "centroide_x")
    private Double centroide_x;
    
    @Column(name = "centroide_y")
    private Double centroide_y;

    @ManyToOne
    @JoinColumn(name = "id_area_verde", nullable = false)
    private AreaVerde area_verde;

    @ManyToOne
    @JoinColumn(name = "id_area_blu", nullable = false)
    private AreaBlu area_blu;
    
    @ManyToOne
    @JoinColumn(name = "id", nullable = false)
    private IncidenzaArborea incidenza_arborea;
    
    @Column(name = "data")
    private Date data;

    public void PoligonoPopolazione() {}

    // Getter e Setter
    public Integer getId() {
        return id_poligono;
    }

    public void setId(Integer id_poligono) {
        this.id_poligono = id_poligono;
    }

    public Date getDataValutazione() {
        return data_valutazione;
    }

    public void setDataValutazione(Date data_valutazione) {
        this.data_valutazione = data_valutazione;
    }

    public Integer getDensitaPerFascia() {
        return densita_per_fascia;
    }

    public void setDensitaPerFascia(Integer densità_per_fascia) {
        this.densita_per_fascia = densità_per_fascia;
    }

    public Integer getNPopolazione() {
        return n_popolazione;
    }

    public void setNPopolazione(Integer n_popolazione) {
        this.n_popolazione = n_popolazione;
    }

    public Geometry getGeometry() {
        return geometria;
    }

    public void setGeometry(Geometry geometria) {
        this.geometria = geometria;
    }

    public Double getCentroideX() {
        return centroide_x;
    }

    public void setCentroideX(Double centroide_x) {
        this.centroide_x = centroide_x;
    }

    public Double getCentroideY() {
        return centroide_y;
    }

    public void setCentroideY(Double centroide_y) {
        this.centroide_y = centroide_y;
    }

    public AreaVerde getAreaVerde() {
        return area_verde;
    }

    public void setAreaVerde(AreaVerde area_verde) {
        this.area_verde = area_verde;
    }

    public AreaBlu getAreaBlu() {
        return area_blu;
    }

    public void setAreaBlu(AreaBlu area_blu) {
        this.area_blu = area_blu;
    }

    public IncidenzaArborea getIncidenza() {
        return incidenza_arborea;
    }

    public void setIncidenza(IncidenzaArborea incidenza_arborea) {
        this.incidenza_arborea = incidenza_arborea;
    }

    public Date getDate() {
        return data;
    }

    public void setData(Date data) {
        this.data = data;
    }
}
