package com.progetto.VEBS.model.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.locationtech.jts.geom.Geometry;

@Entity
@Table(name = "ingresso")
public class Ingresso {

	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id_ingresso;

    @Column(name = "nome")
    private String nome;

    @Column(name = "geometria", columnDefinition = "geometry(Polygon, 3857)")
    private Geometry geometria;

    @ManyToOne
    @JoinColumn(name = "id_area_verde", nullable = false)
    private AreaVerde area_verde;
    
    @ManyToOne
    @JoinColumn(name = "id_area_blu", nullable = false)
    private AreaBlu  area_blu;
    
    //sistemare attributi tabella e classe

    public void IngressoAreaVerde() {}

    // Getter e Setter
    public Integer getId() {
        return id_ingresso;
    }

    public void setId(Integer id_ingresso) {
        this.id_ingresso = id_ingresso;
    }

    public String getNome() {
        return nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Geometry getGeometry() {
        return geometria;
    }

    public void setGeometry(Geometry geometria) {
        this.geometria = geometria;
    }

    public AreaVerde getAreaVerde() {
        return area_verde;
    }

    public void setAreaVerde(AreaVerde area_verde) {
        this.area_verde = area_verde;
    }

    public AreaBlu getAreaBlu() {
        return area_blu;
    }

    public void setAreaBlu(AreaBlu area_blu) {
        this.area_blu = area_blu;
    }
}
