package com.progetto.VEBS.model.entity;

import java.sql.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.locationtech.jts.geom.Geometry;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;

@Entity
@Table(name = "area_verde")
public class AreaVerde {
	

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id_area_verde;

    @Column(name = "nome")
    private String nome;

    @Column(name = "densita_alberi")
    private Double densita_alberi;

    @Column(name = "geometria", columnDefinition = "geometry")
    private Geometry geometria;
    
    @Column(name = "area")
    private Double area;
    
    @Column(name= "data")
    private Date data;

    @ManyToOne
    @JoinColumn(name = "poligono_area_verde", nullable = false)
    private PoligonoAreaVerde poligono_area_verde;

    //mancano campi della tabella ( comune, ubicazione )

    public void AreaVerde() {}

    // Getter e Setter
    public Integer getId() {
        return id_area_verde;
    }

    public void setId(Integer id_area_verde) {
        this.id_area_verde = id_area_verde;
    }

    public String getNome() {
        return nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Double getDensita() {
        return densita_alberi;
    }

    public void setDensita(Double densita_alberi) {
        this.densita_alberi = densita_alberi;
    }

    public Geometry getGeometry() {
        return geometria;
    }

    public void setGeometry(Geometry geometria) {
        this.geometria = geometria;
    }

    public Double getArea() {
        return area;
    }

    public void setArea(Double area) {
        this.area = area;
    }

    public PoligonoAreaVerde getPoligonoAreaVerde() {
        return poligono_area_verde;
    }

    public void setPoligonoAreaVerde(PoligonoAreaVerde poligono_area_verde) {
        this.poligono_area_verde = poligono_area_verde;
    }

    public Date getDate() {
        return data;
    }

    public void setData(Date data) {
        this.data = data;
    }
}
