package com.progetto.VEBS.mapper;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.mapstruct.Mapper;

import com.progetto.VEBS.model.dto.PoligonoPopolazioneDTO;
import com.progetto.VEBS.model.entity.PoligonoPopolazione;

@Mapper(componentModel = "spring")
public interface PoligonoPopolazioneMapper {

	default PoligonoPopolazioneDTO toDTO(PoligonoPopolazione entity) {
		if ( entity == null ) {
            return null;
        }
		PoligonoPopolazioneDTO poligonoPopolazioneDTO = new PoligonoPopolazioneDTO();
		poligonoPopolazioneDTO.setId(entity.getId());
		poligonoPopolazioneDTO.setDataValutazione(entity.getDataValutazione());
		poligonoPopolazioneDTO.setDensitaPerFascia(entity.getDensitaPerFascia());
		poligonoPopolazioneDTO.setWKTGeometry(entity.getGeometry().toText());
		poligonoPopolazioneDTO.setNPopolazione(entity.getNPopolazione());
		poligonoPopolazioneDTO.setCentroideX(entity.getCentroideX());
		poligonoPopolazioneDTO.setCentroideY(entity.getCentroideY());
		poligonoPopolazioneDTO.setAreaVerde(entity.getAreaVerde());
		poligonoPopolazioneDTO.setAreaBlu(entity.getAreaBlu());
		poligonoPopolazioneDTO.setIncidenza(entity.getIncidenza());
        return poligonoPopolazioneDTO;
	}

	
	default PoligonoPopolazione toEntity(PoligonoPopolazioneDTO dto) {
		if ( dto == null ) {
            return null;
        }
		
		PoligonoPopolazione poligonoPopolazione = new PoligonoPopolazione();
		
		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(dto.getWKTGeometry());
			poligonoPopolazione.setGeometry(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		poligonoPopolazione.setId(dto.getId());
		poligonoPopolazione.setDataValutazione(dto.getDataValutazione());
		poligonoPopolazione.setDensitaPerFascia(dto.getDensitaPerFascia());
		poligonoPopolazione.setNPopolazione(dto.getNPopolazione());
		poligonoPopolazione.setCentroideX(dto.getCentroideX());
		poligonoPopolazione.setCentroideY(dto.getCentroideY());
		poligonoPopolazione.setAreaVerde(dto.getAreaVerde());
		poligonoPopolazione.setAreaBlu(dto.getAreaBlu());
		poligonoPopolazione.setIncidenza(dto.getIncidenza());
        return poligonoPopolazione;
	}
}
