package com.progetto.VEBS.mapper;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.mapstruct.Mapper;

import com.progetto.VEBS.model.dto.IngressoDTO;
import com.progetto.VEBS.model.entity.Ingresso;

@Mapper(componentModel = "spring")
public interface IngressoMapper {
	
	default IngressoDTO toDTO(Ingresso entity) {
		if ( entity == null ) {
            return null;
        }
		IngressoDTO ingressoDTO = new IngressoDTO();
		ingressoDTO.setId(entity.getId());
		ingressoDTO.setNome(entity.getNome());
		ingressoDTO.setWKTGeometry(entity.getGeometry().toText());
		ingressoDTO.setAreaVerde(entity.getAreaVerde());
		ingressoDTO.setAreaBlu(entity.getAreaBlu());
        return ingressoDTO;
	}

	
	default Ingresso toEntity(IngressoDTO dto) {
		if ( dto == null ) {
            return null;
        }
		
		Ingresso ingresso = new Ingresso();
		
		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(dto.getWKTGeometry());
			ingresso.setGeometry(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		ingresso.setId(dto.getId());
		ingresso.setNome(dto.getNome());
		ingresso.setAreaVerde(dto.getAreaVerde());
		ingresso.setAreaBlu(dto.getAreaBlu());
        return ingresso;
	}

}
