package com.progetto.VEBS.mapper;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.mapstruct.Mapper;

import com.progetto.VEBS.model.dto.AreaVerdeDTO;
import com.progetto.VEBS.model.entity.AreaVerde;

//Questa tipologia di classi serve per convertire le classi entità con le classi dto e viceversa
@Mapper(componentModel = "spring")
public interface AreaVerdeMapper {
	
	default AreaVerdeDTO toDTO(AreaVerde entity) {
		if ( entity == null ) {
            return null;
        }
		AreaVerdeDTO areaVerdeDTO = new AreaVerdeDTO();
		areaVerdeDTO.setId(entity.getId());
		areaVerdeDTO.setNome(entity.getNome());
		areaVerdeDTO.setDensita(entity.getDensita());
		areaVerdeDTO.setWKTGeometry(entity.getGeometry().toText());
		areaVerdeDTO.setArea(entity.getArea());
		areaVerdeDTO.setPoligonoAreaVerde(entity.getPoligonoAreaVerde());
        return areaVerdeDTO;
	}

	
	default AreaVerde toEntity(AreaVerdeDTO dto) {
		if ( dto == null ) {
            return null;
        }
		
		AreaVerde areaVerde = new AreaVerde();
		
		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(dto.getWKTGeometry());
			areaVerde.setGeometry(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		areaVerde.setId(dto.getId());
		areaVerde.setNome(dto.getNome());
		areaVerde.setDensita(dto.getDensita());
		areaVerde.setArea(dto.getArea());
		areaVerde.setPoligonoAreaVerde(dto.getPoligonoAreaVerde());
        return areaVerde;
	}
}
