package com.progetto.VEBS.mapper;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.mapstruct.Mapper;

import com.progetto.VEBS.model.dto.AreaBluDTO;
import com.progetto.VEBS.model.dto.AreaVerdeDTO;
import com.progetto.VEBS.model.entity.AreaBlu;
import com.progetto.VEBS.model.entity.AreaVerde;

@Mapper(componentModel = "spring")
public interface AreaBluMapper {
	
	default AreaBluDTO toDTO(AreaBlu entity) {
		if ( entity == null ) {
            return null;
        }
		AreaBluDTO areaBluDTO = new AreaBluDTO();
		areaBluDTO.setId(entity.getId());
		areaBluDTO.setNome(entity.getNome());
		areaBluDTO.setWKTGeometry(entity.getGeometry().toText());
        return areaBluDTO;
	}

	
	default AreaBlu toEntity(AreaBluDTO dto) {
		if ( dto == null ) {
            return null;
        }
		
		AreaBlu areaBlu = new AreaBlu();
		
		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(dto.getWKTGeometry());
			areaBlu.setGeometry(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		areaBlu.setId(dto.getId());
		areaBlu.setNome(dto.getNome());
        return areaBlu;
	}
}
