package com.progetto.VEBS.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.progetto.VEBS.model.dto.IngressoDTO;
import com.progetto.VEBS.model.entity.Ingresso;
import com.progetto.VEBS.service.IngressoService;

@RestController
@RequestMapping("/ingresso")
public class IngressoController {

	  @Autowired
	  private final IngressoService ingressoService;

	  public IngressoController(IngressoService ingressoService) {
	    this.ingressoService = ingressoService;
	  }
	  
	  @GetMapping()
	  List<IngressoDTO> getAll() {
		  return ingressoService.getAllIngressi();
	  }

	  @GetMapping("/{id_area_verde}")
	  IngressoDTO getByIdAreaVerde(@PathVariable Integer id_area_verde) {
	    return ingressoService.getIngressoById(id_area_verde);
	  }


	  @GetMapping("/{id_area_blu}")
	  IngressoDTO getByIdAreaBlu(@PathVariable Integer id_area_blu){
	    return ingressoService.getIngressoById(id_area_blu);
	  }
	  
	  @PostMapping("/save")
	  HttpStatus saveRecord(@RequestBody IngressoDTO ingresso_area_verde) { 
		  ingressoService.saveIngresso(ingresso_area_verde);
		  return HttpStatus.CREATED;
	  }
	  
	  @DeleteMapping("/delete/{id_ingresso}")
	  HttpStatus deleteRecord(@PathVariable Integer id_ingresso) {
		  ingressoService.deleteIngressoById(id_ingresso);
		  return HttpStatus.OK;
	  }
	  
	  @PatchMapping("/update")
	  HttpStatus updateRecord(@RequestBody IngressoDTO ingresso) {
		  ingressoService.update(ingresso);
		  return HttpStatus.OK;
	  }
}
