package com.progetto.VEBS.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.progetto.VEBS.model.dto.AreaBluDTO;
import com.progetto.VEBS.model.dto.AreaVerdeDTO;
import com.progetto.VEBS.model.entity.AreaBlu;
import com.progetto.VEBS.model.entity.AreaVerde;
import com.progetto.VEBS.service.AreaVerdeService;

@RestController
@RequestMapping("/areaverde")
public class AreaVerdeController {
	
	  @Autowired
	  private final AreaVerdeService areaVerdeService;

	  public AreaVerdeController(AreaVerdeService areaVerdeService) {
	    this.areaVerdeService = areaVerdeService;
	  }

	  @GetMapping()
	  List<AreaVerdeDTO> getAll() {
	        return areaVerdeService.getAllAreeVerdi();
	  }

	  @GetMapping("/{id_area_verde}")
	  AreaVerdeDTO getById(@PathVariable Integer id_area_verde) {
	    return areaVerdeService.getAreaVerdeById(id_area_verde);
	  }
	  
	  @PostMapping("/save")
	  HttpStatus saveRecord(@RequestBody AreaVerdeDTO areaverde) { 
		  areaVerdeService.saveAreaVerde(areaverde);
		  return HttpStatus.CREATED;
	  }
	  
	  @DeleteMapping("/delete/{id_area}")
	  HttpStatus deleteRecord(@PathVariable Integer id_area) {
		  areaVerdeService.deleteAreaVerdeById(id_area);
		  return HttpStatus.OK;
	  }
	  
	  @PatchMapping("/update")
	  HttpStatus updateRecord(@RequestBody AreaVerdeDTO area) {
		  areaVerdeService.updateAreaVerde(area);
		  return HttpStatus.OK;
	  }
	  
}
