package com.progetto.VEBS.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.progetto.VEBS.model.dto.AreaBluDTO;
import com.progetto.VEBS.model.entity.AreaBlu;
import com.progetto.VEBS.service.AreaBluService;

@RestController
@RequestMapping("/areablu")
public class AreaBluController {

	  @Autowired
	  private final AreaBluService areaBluService;

	  public AreaBluController(AreaBluService areaBluService) {
	    this.areaBluService = areaBluService;
	  }

	  @GetMapping()
	  List<AreaBluDTO> getAll() {
	        return areaBluService.getAllAreeBlu();
	  }

	  @GetMapping("/{id_area_blu}")
	  AreaBluDTO getById(@PathVariable Integer id_area_blu) {
	    return areaBluService.getAreaBluById(id_area_blu);
	  }
	  
	  @PostMapping("/save")
	  HttpStatus saveRecord(@RequestBody AreaBluDTO areablu) { 
		  areaBluService.saveAreaBlu(areablu);
		  return HttpStatus.CREATED;
	  }
	  
	  @DeleteMapping("/delete/{id_area}")
	  HttpStatus deleteRecord(@PathVariable Integer id_area) {
		  areaBluService.deleteAreaBluById(id_area);
		  return HttpStatus.OK;
	  }
	  
	  @PatchMapping("/update")
	  HttpStatus updateRecord(@RequestBody AreaBluDTO area) {
		  areaBluService.updateAreaBlu(area);
		  return HttpStatus.OK;
	  }
	  
}
