package com.progetto.ispra.model.entity;

import org.locationtech.jts.geom.Geometry;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;

@Entity
@Table(name = "area_verde")
public class AreaVerde {
	

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id_area_verde;

    @Column(name = "nome")
    private String nome;

    @Column(name = "densità_alberi")
    private Integer densita_alberi;

    @Column(name = "geometria", columnDefinition = "geometry(Polygon, 3857)")
    private Geometry geometria;
    


    public void AreaVerde() {}
    
    
    public void AreaVerde(Integer id, String nome, Integer densita, Geometry geometria) {
    	this.id_area_verde = id;
    	this.nome = nome;
    	this.densita_alberi = densita;
    	this.geometria = geometria;
    }

    // Getter e Setter
    public Integer getId() {
        return id_area_verde;
    }

    public void setId(Integer id_area_verde) {
        this.id_area_verde = id_area_verde;
    }

    public String getNome() {
        return nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Integer getDensita() {
        return densita_alberi;
    }

    public void setDensita(Integer densita_alberi) {
        this.densita_alberi = densita_alberi;
    }

    public Geometry getGeometry() {
        return geometria;
    }

    public void setGeometry(Geometry geometria) {
        this.geometria = geometria;
    }

    public String toString() {
        return "AreaVerde ( " + " id_area_verde = " + id_area_verde.toString() + "nome = " + nome.toString() +
        		" densita_alberi = " + densita_alberi.toString() + " geometria = " + geometria.toString();
    }
}
