package com.progetto.ispra.model.entity;

import org.locationtech.jts.geom.Geometry;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;

@Entity
@Table(name = "area_blu")
public class AreaBlu {


    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id_area_blu;

    @Column(name = "nome")
    private String nome;

    @Column(name = "geometria", columnDefinition = "geometry(Polygon, 3857)")
    private Geometry geometria;
    


    public void AreaBlu() {}
    
    
    public void AreaBlu(Integer id, String nome, Geometry geometria) {
    	this.id_area_blu = id;
    	this.nome = nome;
    	this.geometria = geometria;
    }

    // Getter e Setter
    public Integer getId() {
        return id_area_blu;
    }

    public void setId(Integer id_area_blu) {
        this.id_area_blu = id_area_blu;
    }

    public String getNome() {
        return nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Geometry getGeometry() {
        return geometria;
    }

    public void setGeometry(Geometry geometria) {
        this.geometria = geometria;
    }

    public String toString() {
        return "AreaBlu ( " + " id_area_blu = " + id_area_blu.toString() + "nome = " + nome.toString() +
        		" geometria = " + geometria.toString();
    }
	
}

