/*
 * Decompiled with CFR 0.152.
 */
package org.n52.jackson.datatype.jts;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Optional;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public enum GeometryType {
    POINT("Point"),
    LINE_STRING("LineString"),
    POLYGON("Polygon"),
    MULTI_POINT("MultiPoint"),
    MULTI_LINE_STRING("MultiLineString"),
    MULTI_POLYGON("MultiPolygon"),
    GEOMETRY_COLLECTION("GeometryCollection");

    private final String type;

    private GeometryType(String type) {
        this.type = type;
    }

    int mask() {
        return 1 << this.ordinal();
    }

    @JsonValue
    public String toString() {
        return this.type;
    }

    @JsonCreator
    public static Optional<GeometryType> fromString(String value) {
        for (GeometryType type : GeometryType.values()) {
            if (!type.toString().equals(value)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    public static Optional<GeometryType> forGeometry(Geometry geometry) {
        if (geometry == null) {
            return Optional.empty();
        }
        if (geometry instanceof Polygon) {
            return Optional.of(POLYGON);
        }
        if (geometry instanceof Point) {
            return Optional.of(POINT);
        }
        if (geometry instanceof MultiPoint) {
            return Optional.of(MULTI_POINT);
        }
        if (geometry instanceof MultiPolygon) {
            return Optional.of(MULTI_POLYGON);
        }
        if (geometry instanceof LineString) {
            return Optional.of(LINE_STRING);
        }
        if (geometry instanceof MultiLineString) {
            return Optional.of(MULTI_LINE_STRING);
        }
        if (geometry instanceof GeometryCollection) {
            return Optional.of(GEOMETRY_COLLECTION);
        }
        return Optional.empty();
    }
}

