/*
 * Decompiled with CFR 0.152.
 */
package org.n52.jackson.datatype.jts;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.n52.jackson.datatype.jts.GeometryType;
import org.n52.jackson.datatype.jts.IncludeBoundingBox;

public class GeometrySerializer
extends JsonSerializer<Geometry> {
    static final int DEFAULT_DECIMAL_PLACES = 8;
    private final NumberFormat decimalFormat;
    private final IncludeBoundingBox includeBoundingBox;

    public GeometrySerializer() {
        this(null, 8);
    }

    public GeometrySerializer(@Nullable IncludeBoundingBox includeBoundingBox) {
        this(includeBoundingBox, 8);
    }

    public GeometrySerializer(@Nullable IncludeBoundingBox includeBoundingBox, int decimalPlaces) {
        this.includeBoundingBox = Optional.ofNullable(includeBoundingBox).orElseGet(IncludeBoundingBox::never);
        if (decimalPlaces < 0) {
            throw new IllegalArgumentException("decimalPlaces < 0");
        }
        this.decimalFormat = this.createNumberFormat(decimalPlaces);
    }

    private NumberFormat createNumberFormat(int decimalPlaces) {
        NumberFormat format = DecimalFormat.getInstance(Locale.ROOT);
        format.setRoundingMode(RoundingMode.HALF_UP);
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(decimalPlaces);
        format.setGroupingUsed(false);
        return format;
    }

    public Class<Geometry> handledType() {
        return Geometry.class;
    }

    public void serialize(Geometry geometry, JsonGenerator generator, SerializerProvider provider) throws IOException {
        if (geometry == null) {
            generator.writeNull();
        } else if (geometry instanceof Polygon) {
            this.serialize((Polygon)geometry, generator, provider);
        } else if (geometry instanceof Point) {
            this.serialize((Point)geometry, generator, provider);
        } else if (geometry instanceof MultiPoint) {
            this.serialize((MultiPoint)geometry, generator, provider);
        } else if (geometry instanceof MultiPolygon) {
            this.serialize((MultiPolygon)geometry, generator, provider);
        } else if (geometry instanceof LineString) {
            this.serialize((LineString)geometry, generator, provider);
        } else if (geometry instanceof MultiLineString) {
            this.serialize((MultiLineString)geometry, generator, provider);
        } else if (geometry instanceof GeometryCollection) {
            this.serialize((GeometryCollection)geometry, generator, provider);
        } else {
            throw JsonMappingException.from((JsonGenerator)generator, (String)String.format("Geometry type %s is not supported.", geometry.getClass().getName()));
        }
    }

    private void serialize(GeometryCollection value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        this.serializeTypeAndBoundingBox(GeometryType.GEOMETRY_COLLECTION, (Geometry)value, generator);
        generator.writeArrayFieldStart("geometries");
        for (int i = 0; i != value.getNumGeometries(); ++i) {
            this.serialize(value.getGeometryN(i), generator, provider);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    private void serialize(MultiPoint value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        this.serializeTypeAndBoundingBox(GeometryType.MULTI_POINT, (Geometry)value, generator);
        generator.writeArrayFieldStart("coordinates");
        for (int i = 0; i < value.getNumGeometries(); ++i) {
            this.serializeCoordinate((Point)value.getGeometryN(i), generator, provider);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    private void serialize(MultiLineString value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        this.serializeTypeAndBoundingBox(GeometryType.MULTI_LINE_STRING, (Geometry)value, generator);
        generator.writeArrayFieldStart("coordinates");
        for (int i = 0; i < value.getNumGeometries(); ++i) {
            this.serializeCoordinates((LineString)value.getGeometryN(i), generator, provider);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    private void serialize(MultiPolygon value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        this.serializeTypeAndBoundingBox(GeometryType.MULTI_POLYGON, (Geometry)value, generator);
        generator.writeArrayFieldStart("coordinates");
        for (int i = 0; i < value.getNumGeometries(); ++i) {
            this.serializeCoordinates((Polygon)value.getGeometryN(i), generator, provider);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    private void serialize(Polygon value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        this.serializeTypeAndBoundingBox(GeometryType.POLYGON, (Geometry)value, generator);
        generator.writeFieldName("coordinates");
        this.serializeCoordinates(value, generator, provider);
        generator.writeEndObject();
    }

    private void serialize(LineString value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        this.serializeTypeAndBoundingBox(GeometryType.LINE_STRING, (Geometry)value, generator);
        generator.writeFieldName("coordinates");
        this.serializeCoordinates(value, generator, provider);
        generator.writeEndObject();
    }

    private void serialize(Point value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        this.serializeTypeAndBoundingBox(GeometryType.POINT, (Geometry)value, generator);
        generator.writeFieldName("coordinates");
        this.serializeCoordinate(value, generator, provider);
        generator.writeEndObject();
    }

    private void serializeTypeAndBoundingBox(GeometryType type, Geometry geometry, JsonGenerator generator) throws IOException {
        generator.writeStringField("type", type.toString());
        if (this.includeBoundingBox.shouldIncludeBoundingBoxFor(type) && !geometry.isEmpty()) {
            Envelope envelope = geometry.getEnvelopeInternal();
            generator.writeArrayFieldStart("bbox");
            generator.writeNumber(envelope.getMinX());
            generator.writeNumber(envelope.getMinY());
            generator.writeNumber(envelope.getMaxX());
            generator.writeNumber(envelope.getMaxY());
            generator.writeEndArray();
        }
    }

    private void serializeCoordinates(Polygon value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartArray();
        this.serializeCoordinates((LineString)value.getExteriorRing(), generator, provider);
        for (int i = 0; i < value.getNumInteriorRing(); ++i) {
            this.serializeCoordinates((LineString)value.getInteriorRingN(i), generator, provider);
        }
        generator.writeEndArray();
    }

    private void serializeCoordinates(LineString value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        this.serializeCoordinates(value.getCoordinateSequence(), generator, provider);
    }

    private void serializeCoordinates(CoordinateSequence value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartArray();
        for (int i = 0; i < value.size(); ++i) {
            this.serializeCoordinate(value.getCoordinate(i), generator, provider);
        }
        generator.writeEndArray();
    }

    private void serializeCoordinate(Point value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        this.serializeCoordinate(value.getCoordinate(), generator, provider);
    }

    private void serializeCoordinate(Coordinate value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartArray();
        generator.writeNumber(this.decimalFormat.format(value.getX()));
        generator.writeNumber(this.decimalFormat.format(value.getY()));
        if (!Double.isNaN(value.getZ()) && Double.isFinite(value.getZ())) {
            generator.writeNumber(this.decimalFormat.format(value.getZ()));
        }
        generator.writeEndArray();
    }
}

