/*
 * Decompiled with CFR 0.152.
 */
package org.n52.jackson.datatype.jts;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Objects;

public class TypeSafeJsonDeserializer<T>
extends JsonDeserializer<T> {
    private final JsonDeserializer<? super T> delegate;
    private final JavaType type;

    public TypeSafeJsonDeserializer(Class<? extends T> type, JsonDeserializer<? super T> delegate) {
        this(TypeFactory.defaultInstance().constructType(type), delegate);
    }

    public TypeSafeJsonDeserializer(JavaType type, JsonDeserializer<? super T> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.type = Objects.requireNonNull(type);
    }

    public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
        Object obj = this.delegate.deserialize(p, context);
        if (obj == null) {
            return null;
        }
        if (this.type.isTypeOrSuperTypeOf(obj.getClass())) {
            return (T)obj;
        }
        throw JsonMappingException.from((DeserializationContext)context, (String)String.format("Invalid type for %s: %s", this.type, obj.getClass()));
    }
}

