/*
 * Decompiled with CFR 0.152.
 */
package org.n52.jackson.datatype.jts;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.n52.jackson.datatype.jts.GeometryDeserializer;
import org.n52.jackson.datatype.jts.GeometrySerializer;
import org.n52.jackson.datatype.jts.IncludeBoundingBox;
import org.n52.jackson.datatype.jts.TypeSafeJsonDeserializer;
import org.n52.jackson.datatype.jts.VersionInfo;

public class JtsModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private final GeometryFactory geometryFactory;
    private final IncludeBoundingBox includeBoundingBox;
    private final int decimalPlaces;

    public JtsModule() {
        this(null, null, 8);
    }

    public JtsModule(int decimalPlaces) {
        this(null, null, decimalPlaces);
    }

    public JtsModule(@Nullable GeometryFactory geometryFactory) {
        this(geometryFactory, null, 8);
    }

    public JtsModule(@Nullable GeometryFactory geometryFactory, int decimalPlaces) {
        this(geometryFactory, null, decimalPlaces);
    }

    public JtsModule(@Nullable IncludeBoundingBox includeBoundingBox) {
        this(null, includeBoundingBox, 8);
    }

    public JtsModule(@Nullable IncludeBoundingBox includeBoundingBox, int decimalPlaces) {
        this(null, includeBoundingBox, decimalPlaces);
    }

    public JtsModule(@Nullable GeometryFactory geometryFactory, @Nullable IncludeBoundingBox includeBoundingBox) {
        this(geometryFactory, includeBoundingBox, 8);
    }

    public JtsModule(@Nullable GeometryFactory geometryFactory, @Nullable IncludeBoundingBox includeBoundingBox, int decimalPlaces) {
        super(VersionInfo.getVersion());
        this.geometryFactory = geometryFactory;
        this.includeBoundingBox = includeBoundingBox;
        if (decimalPlaces < 0) {
            throw new IllegalArgumentException("decimalPlaces < 0");
        }
        this.decimalPlaces = decimalPlaces;
    }

    public void setupModule(Module.SetupContext context) {
        JsonDeserializer<Geometry> deserializer = this.getDeserializer();
        this.addSerializer(Geometry.class, this.getSerializer());
        this.addDeserializer(Geometry.class, deserializer);
        this.addDeserializer(Point.class, new TypeSafeJsonDeserializer<Geometry>(Point.class, deserializer));
        this.addDeserializer(LineString.class, new TypeSafeJsonDeserializer<Geometry>(LineString.class, deserializer));
        this.addDeserializer(Polygon.class, new TypeSafeJsonDeserializer<Geometry>(Polygon.class, deserializer));
        this.addDeserializer(MultiPoint.class, new TypeSafeJsonDeserializer<Geometry>(MultiPoint.class, deserializer));
        this.addDeserializer(MultiLineString.class, new TypeSafeJsonDeserializer<Geometry>(MultiLineString.class, deserializer));
        this.addDeserializer(MultiPolygon.class, new TypeSafeJsonDeserializer<Geometry>(MultiPolygon.class, deserializer));
        this.addDeserializer(GeometryCollection.class, new TypeSafeJsonDeserializer<Geometry>(GeometryCollection.class, deserializer));
        super.setupModule(context);
    }

    private JsonSerializer<Geometry> getSerializer() {
        return new GeometrySerializer(this.includeBoundingBox, this.decimalPlaces);
    }

    private JsonDeserializer<Geometry> getDeserializer() {
        return new GeometryDeserializer(this.geometryFactory);
    }
}

