/*
 * Decompiled with CFR 0.152.
 */
package org.n52.jackson.datatype.jts;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.n52.jackson.datatype.jts.GeometryType;

public class GeometryDeserializer
extends JsonDeserializer<Geometry> {
    private static final int DEFAULT_SRID = 4326;
    private static final GeometryFactory DEFAULT_GEOMETRY_FACTORY = GeometryDeserializer.getDefaultGeometryFactory();
    private final GeometryFactory geometryFactory;

    public GeometryDeserializer() {
        this(null);
    }

    public GeometryDeserializer(@Nullable GeometryFactory geometryFactory) {
        this.geometryFactory = Optional.ofNullable(geometryFactory).orElse(DEFAULT_GEOMETRY_FACTORY);
    }

    public Geometry deserialize(JsonParser p, DeserializationContext context) throws IOException {
        return this.deserializeGeometry((JsonNode)p.readValueAs(JsonNode.class), context);
    }

    private Geometry deserializeGeometry(JsonNode node, DeserializationContext context) throws JsonMappingException {
        String typeName = node.get("type").asText();
        GeometryType type = GeometryType.fromString(typeName).orElseThrow(() -> this.invalidGeometryType(context, typeName));
        switch (type) {
            case POINT: {
                return this.deserializePoint(node, context);
            }
            case MULTI_POINT: {
                return this.deserializeMultiPoint(node, context);
            }
            case LINE_STRING: {
                return this.deserializeLineString(node, context);
            }
            case MULTI_LINE_STRING: {
                return this.deserializeMultiLineString(node, context);
            }
            case POLYGON: {
                return this.deserializePolygon(node, context);
            }
            case MULTI_POLYGON: {
                return this.deserializeMultiPolygon(node, context);
            }
            case GEOMETRY_COLLECTION: {
                return this.deserializeGeometryCollection(node, context);
            }
        }
        throw this.invalidGeometryType(context, typeName);
    }

    private JsonMappingException invalidGeometryType(DeserializationContext context, String typeName) {
        return JsonMappingException.from((DeserializationContext)context, (String)("Invalid geometry type: " + typeName));
    }

    private Point deserializePoint(JsonNode node, DeserializationContext context) throws JsonMappingException {
        JsonNode coordinates = this.getArray(node, context, "coordinates");
        return this.geometryFactory.createPoint(this.deserializeCoordinate(coordinates, context));
    }

    private Polygon deserializePolygon(JsonNode node, DeserializationContext context) throws JsonMappingException {
        JsonNode coordinates = this.getArray(node, context, "coordinates");
        return this.deserializeLinearRings(coordinates, context);
    }

    private MultiPolygon deserializeMultiPolygon(JsonNode node, DeserializationContext context) throws JsonMappingException {
        JsonNode coordinates = this.getArray(node, context, "coordinates");
        Polygon[] polygons = new Polygon[coordinates.size()];
        for (int i = 0; i != coordinates.size(); ++i) {
            polygons[i] = this.deserializeLinearRings(coordinates.get(i), context);
        }
        return this.geometryFactory.createMultiPolygon(polygons);
    }

    private MultiPoint deserializeMultiPoint(JsonNode node, DeserializationContext context) throws JsonMappingException {
        JsonNode coordinates = this.getArray(node, context, "coordinates");
        Coordinate[] coords = this.deserializeCoordinates(coordinates, context);
        return this.geometryFactory.createMultiPointFromCoords(coords);
    }

    private GeometryCollection deserializeGeometryCollection(JsonNode node, DeserializationContext context) throws JsonMappingException {
        JsonNode geometries = this.getArray(node, context, "geometries");
        Geometry[] geom = new Geometry[geometries.size()];
        for (int i = 0; i != geometries.size(); ++i) {
            geom[i] = this.deserializeGeometry(geometries.get(i), context);
        }
        return this.geometryFactory.createGeometryCollection(geom);
    }

    private MultiLineString deserializeMultiLineString(JsonNode node, DeserializationContext context) throws JsonMappingException {
        JsonNode coordinates = this.getArray(node, context, "coordinates");
        LineString[] lineStrings = this.lineStringsFromJson(coordinates, context);
        return this.geometryFactory.createMultiLineString(lineStrings);
    }

    private LineString[] lineStringsFromJson(JsonNode node, DeserializationContext context) throws JsonMappingException {
        LineString[] strings = new LineString[node.size()];
        for (int i = 0; i != node.size(); ++i) {
            Coordinate[] coordinates = this.deserializeCoordinates(node.get(i), context);
            strings[i] = this.geometryFactory.createLineString(coordinates);
        }
        return strings;
    }

    private LineString deserializeLineString(JsonNode node, DeserializationContext context) throws JsonMappingException {
        JsonNode coordinates = this.getArray(node, context, "coordinates");
        Coordinate[] coords = this.deserializeCoordinates(coordinates, context);
        return this.geometryFactory.createLineString(coords);
    }

    private Coordinate[] deserializeCoordinates(JsonNode node, DeserializationContext context) throws JsonMappingException {
        Coordinate[] points = new Coordinate[node.size()];
        for (int i = 0; i != node.size(); ++i) {
            points[i] = this.deserializeCoordinate(node.get(i), context);
        }
        return points;
    }

    private Polygon deserializeLinearRings(JsonNode node, DeserializationContext context) throws JsonMappingException {
        LinearRing shell = this.deserializeLinearRing(node.get(0), context);
        LinearRing[] holes = new LinearRing[node.size() - 1];
        for (int i = 1; i < node.size(); ++i) {
            holes[i - 1] = this.deserializeLinearRing(node.get(i), context);
        }
        return this.geometryFactory.createPolygon(shell, holes);
    }

    private LinearRing deserializeLinearRing(JsonNode node, DeserializationContext context) throws JsonMappingException {
        Coordinate[] coordinates = this.deserializeCoordinates(node, context);
        return this.geometryFactory.createLinearRing(coordinates);
    }

    private Coordinate deserializeCoordinate(JsonNode node, DeserializationContext context) throws JsonMappingException {
        if (node.size() < 2) {
            throw JsonMappingException.from((DeserializationContext)context, (String)String.format("Invalid number of ordinates: %d", node.size()));
        }
        double x = this.getOrdinate(node, 0, context);
        double y = this.getOrdinate(node, 1, context);
        if (node.size() < 3) {
            return new Coordinate(x, y);
        }
        double z = this.getOrdinate(node, 2, context);
        return new Coordinate(x, y, z);
    }

    private JsonNode getArray(JsonNode node, DeserializationContext context, String fieldName) throws JsonMappingException {
        JsonNode coordinates = node.get(fieldName);
        if (coordinates != null && !coordinates.isArray()) {
            throw JsonMappingException.from((DeserializationContext)context, (String)("Invalid coordinates, expecting an array but got: " + coordinates.getNodeType().toString()));
        }
        return coordinates;
    }

    private double getOrdinate(JsonNode node, int i, DeserializationContext context) throws JsonMappingException {
        JsonNode ordinate = node.get(i);
        if (!ordinate.isNumber()) {
            throw JsonMappingException.from((DeserializationContext)context, (String)("Invalid coordinates, expecting numbers but got: " + ordinate.getNodeType().toString()));
        }
        return ordinate.asDouble();
    }

    private static GeometryFactory getDefaultGeometryFactory() {
        return new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
    }
}

