/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.criterion.ExpressionUtil;
import org.hibernate.spatial.dialect.oracle.OracleSpatial10gDialect;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.locationtech.jts.geom.Geometry;

public class DWithinExpression
implements Criterion {
    private final String propertyName;
    private final Geometry geometry;
    private final double distance;

    public DWithinExpression(String propertyName, Geometry geometry, double distance) {
        this.propertyName = propertyName;
        this.geometry = geometry;
        this.distance = distance;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String column = ExpressionUtil.findColumn(this.propertyName, criteria, criteriaQuery);
        SpatialDialect spatialDialect = ExpressionUtil.getSpatialDialect(criteriaQuery, SpatialFunction.dwithin);
        return spatialDialect.getDWithinSQL(column);
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        SpatialDialect spatialDialect = ExpressionUtil.getSpatialDialect(criteriaQuery, SpatialFunction.dwithin);
        TypedValue typedDistanceValue = new TypedValue((Type)StandardBasicTypes.DOUBLE, (Object)this.distance);
        if (spatialDialect instanceof OracleSpatial10gDialect) {
            typedDistanceValue = new TypedValue((Type)StandardBasicTypes.STRING, (Object)("distance=" + this.distance));
        }
        return new TypedValue[]{criteriaQuery.getTypedValue(criteria, this.propertyName, (Object)this.geometry), typedDistanceValue};
    }
}

