/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.gem;

import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.Gem;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.GemValue;

public class XmlElementRefGem
implements Gem {
    private final GemValue<TypeMirror> type;
    private final GemValue<String> namespace;
    private final GemValue<String> name;
    private final GemValue<Boolean> required;
    private final boolean isValid;
    private final AnnotationMirror mirror;

    private XmlElementRefGem(BuilderImpl builder) {
        this.type = builder.type;
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.required = builder.required;
        this.isValid = this.type != null && this.type.isValid() && this.namespace != null && this.namespace.isValid() && this.name != null && this.name.isValid() && this.required != null && this.required.isValid();
        this.mirror = builder.mirror;
    }

    public GemValue<TypeMirror> type() {
        return this.type;
    }

    public GemValue<String> namespace() {
        return this.namespace;
    }

    public GemValue<String> name() {
        return this.name;
    }

    public GemValue<Boolean> required() {
        return this.required;
    }

    @Override
    public AnnotationMirror mirror() {
        return this.mirror;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public static XmlElementRefGem instanceOn(Element element) {
        return XmlElementRefGem.build(element, new BuilderImpl());
    }

    public static XmlElementRefGem instanceOn(AnnotationMirror mirror) {
        return XmlElementRefGem.build(mirror, new BuilderImpl());
    }

    public static <T> T build(Element element, Builder<T> builder) {
        AnnotationMirror mirror = element.getAnnotationMirrors().stream().filter(a -> "javax.xml.bind.annotation.XmlElementRef".contentEquals(((TypeElement)a.getAnnotationType().asElement()).getQualifiedName())).findAny().orElse(null);
        return XmlElementRefGem.build(mirror, builder);
    }

    public static <T> T build(AnnotationMirror mirror, Builder<T> builder) {
        if (mirror == null || builder == null) {
            return null;
        }
        List<ExecutableElement> enclosed = ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements());
        HashMap defaultValues = new HashMap(enclosed.size());
        enclosed.forEach(e -> defaultValues.put(e.getSimpleName().toString(), e.getDefaultValue()));
        HashMap values = new HashMap(enclosed.size());
        mirror.getElementValues().entrySet().forEach(e -> values.put(((ExecutableElement)e.getKey()).getSimpleName().toString(), (AnnotationValue)e.getValue()));
        for (String methodName : defaultValues.keySet()) {
            if ("type".equals(methodName)) {
                builder.setType(GemValue.create((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), TypeMirror.class));
                continue;
            }
            if ("namespace".equals(methodName)) {
                builder.setNamespace(GemValue.create((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), String.class));
                continue;
            }
            if ("name".equals(methodName)) {
                builder.setName(GemValue.create((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), String.class));
                continue;
            }
            if (!"required".equals(methodName)) continue;
            builder.setRequired(GemValue.create((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), Boolean.class));
        }
        builder.setMirror(mirror);
        return builder.build();
    }

    private static class BuilderImpl
    implements Builder<XmlElementRefGem> {
        private GemValue<TypeMirror> type;
        private GemValue<String> namespace;
        private GemValue<String> name;
        private GemValue<Boolean> required;
        private AnnotationMirror mirror;

        private BuilderImpl() {
        }

        @Override
        public Builder setType(GemValue<TypeMirror> type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder setNamespace(GemValue<String> namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public Builder setName(GemValue<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder setRequired(GemValue<Boolean> required) {
            this.required = required;
            return this;
        }

        @Override
        public Builder setMirror(AnnotationMirror mirror) {
            this.mirror = mirror;
            return this;
        }

        @Override
        public XmlElementRefGem build() {
            return new XmlElementRefGem(this);
        }
    }

    public static interface Builder<T> {
        public Builder setType(GemValue<TypeMirror> var1);

        public Builder setNamespace(GemValue<String> var1);

        public Builder setName(GemValue<String> var1);

        public Builder setRequired(GemValue<Boolean> var1);

        public Builder setMirror(AnnotationMirror var1);

        public T build();
    }
}

