/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;

class WktDialect {
    static final Map<GeometryType, Pattern> GEOMETRY_TYPE_PATTERN_MAP = new HashMap<GeometryType, Pattern>();

    WktDialect() {
    }

    private static void addToMap(GeometryType tpe, String pattern) {
        GEOMETRY_TYPE_PATTERN_MAP.put(tpe, Pattern.compile(pattern, 2));
    }

    public Map<GeometryType, Pattern> geometryTypePatternMap() {
        return Collections.unmodifiableMap(GEOMETRY_TYPE_PATTERN_MAP);
    }

    void addGeometryTag(StringBuilder buffer, Geometry<?> geometry) {
        switch (geometry.getGeometryType()) {
            case POINT: {
                buffer.append("POINT");
                return;
            }
            case LINEARRING: 
            case LINESTRING: {
                buffer.append("LINESTRING");
                return;
            }
            case POLYGON: {
                buffer.append("POLYGON");
                return;
            }
            case MULTIPOINT: {
                buffer.append("MULTIPOINT");
                return;
            }
            case MULTILINESTRING: {
                buffer.append("MULTILINESTRING");
                return;
            }
            case MULTIPOLYGON: {
                buffer.append("MULTIPOLYGON");
                return;
            }
            case GEOMETRYCOLLECTION: {
                buffer.append("GEOMETRYCOLLECTION");
                return;
            }
        }
        throw new IllegalStateException(String.format("Geometry type %s cannot be encoded in WKT.", geometry.getGeometryType().getCamelCased()));
    }

    boolean isLimitedTo2D() {
        return false;
    }

    boolean writeMultiPointAsListOfPositions() {
        return false;
    }

    void addGeometryZMMarker(StringBuilder buffer, Geometry<?> geometry) {
        if (geometry.hasM() && geometry.getCoordinateDimension() < 4) {
            buffer.append('M');
        }
    }

    public void addSrid(StringBuilder builder, int srid) {
    }

    static {
        WktDialect.addToMap(GeometryType.POINT, "point");
        WktDialect.addToMap(GeometryType.LINESTRING, "linestring");
        WktDialect.addToMap(GeometryType.POLYGON, "polygon");
        WktDialect.addToMap(GeometryType.GEOMETRYCOLLECTION, "geometrycollection");
        WktDialect.addToMap(GeometryType.MULTIPOINT, "multipoint");
        WktDialect.addToMap(GeometryType.MULTILINESTRING, "multilinestring");
        WktDialect.addToMap(GeometryType.MULTIPOLYGON, "multipolygon");
    }
}

