/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.BaseWkbVisitor;
import org.geolatte.geom.codec.WkbDialect;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

class PostgisWkbV1Dialect
extends WkbDialect {
    public static final WkbDialect INSTANCE = new PostgisWkbV1Dialect();

    PostgisWkbV1Dialect() {
    }

    @Override
    boolean emptyPointAsNaN() {
        return false;
    }

    @Override
    protected <P extends Position> Long geometryTypeCode(Geometry<P> geometry) {
        if (geometry.isEmpty() && geometry.getGeometryType() == GeometryType.POINT) {
            return WKB_GEOMETRYCOLLECTION;
        }
        return super.geometryTypeCode(geometry);
    }

    @Override
    GeometryType parseType(long tpe) {
        return super.parseType(tpe & 0xFFFFL);
    }

    @Override
    protected <P extends Position> int extraHeaderSize(Geometry<P> geom) {
        return geom.getSRID() > 0 ? 4 : 0;
    }

    @Override
    <P extends Position> BaseWkbVisitor<P> mkVisitor(Geometry<P> geom, ByteOrder bo) {
        return new PostgisWkbVisitor(this.mkByteBuffer(geom, bo), this);
    }

    static class PostgisWkbVisitor<P extends Position>
    extends BaseWkbVisitor<P> {
        private boolean hasWrittenSrid = false;

        PostgisWkbVisitor(ByteBuffer byteBuffer, WkbDialect dialect) {
            super(byteBuffer, dialect);
        }

        @Override
        protected void writeTypeCodeAndSrid(Geometry<P> geometry, ByteBuffer output) {
            long typeCode = this.dialect().geometryTypeCode(geometry);
            boolean hasSrid = geometry.getSRID() > 0;
            CoordinateReferenceSystem<P> crs = geometry.getCoordinateReferenceSystem();
            if (hasSrid && !this.hasWrittenSrid) {
                typeCode |= 0x20000000L;
            }
            if (geometry.hasM()) {
                typeCode |= 0x40000000L;
            }
            if (geometry.hasZ()) {
                typeCode |= Integer.MIN_VALUE;
            }
            output.putUInt(typeCode);
            if (hasSrid && !this.hasWrittenSrid) {
                output.putInt(geometry.getSRID());
                this.hasWrittenSrid = true;
            }
        }
    }
}

