/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Point;
import org.geolatte.geom.Position;
import org.geolatte.geom.Positions;
import org.geolatte.geom.codec.support.Holder;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class PointHolder
extends Holder {
    private final List<Double> coordinates;

    public PointHolder() {
        this.coordinates = new ArrayList<Double>(4);
    }

    public PointHolder(double[] co) {
        this.coordinates = DoubleStream.of(co).boxed().collect(Collectors.toList());
    }

    public void push(double co) {
        this.coordinates.add(co);
    }

    @Override
    public boolean isEmpty() {
        return this.coordinates.size() == 0;
    }

    public double[] getCoordinates() {
        return this.coordinates.stream().mapToDouble(x -> x).toArray();
    }

    @Override
    public int getCoordinateDimension() {
        return this.coordinates.size();
    }

    public <P extends Position> P toPosition(CoordinateReferenceSystem<P> crs) {
        double[] co = this.getCoordinateDimension() != crs.getCoordinateDimension() ? this.toDimension(this.getCoordinates(), crs.getCoordinateDimension()) : this.getCoordinates();
        return Positions.mkPosition(crs.getPositionClass(), co);
    }

    public <P extends Position> Point<P> toGeometry(CoordinateReferenceSystem<P> crs, GeometryType geomType) {
        if (this.isEmpty() || Double.isNaN(this.coordinates.get(0))) {
            return Geometries.mkEmptyPoint(crs);
        }
        return Geometries.mkPoint(this.toPosition(crs), crs);
    }

    private double[] toDimension(double[] orig, int targetDim) {
        return Arrays.copyOf(orig, targetDim);
    }
}

