/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.BaseWkbVisitor;
import org.geolatte.geom.codec.UnsupportedConversionException;
import org.geolatte.geom.codec.WkbDialect;
import org.geolatte.geom.codec.WkbGeometryType;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

class HANAWkbVisitor<P extends Position>
extends BaseWkbVisitor<P> {
    private boolean hasWrittenSrid = false;

    HANAWkbVisitor(ByteBuffer byteBuffer, WkbDialect dialect) {
        super(byteBuffer, dialect);
    }

    @Override
    protected void writeTypeCodeAndSrid(Geometry<P> geometry, ByteBuffer output) {
        int typeCode = this.geometryTypeCode(geometry);
        CoordinateReferenceSystem<P> crs = geometry.getCoordinateReferenceSystem();
        if (!this.hasWrittenSrid) {
            typeCode |= 0x20000000;
        }
        if (geometry.hasM()) {
            typeCode |= 0x40000000;
        }
        if (geometry.hasZ()) {
            typeCode |= Integer.MIN_VALUE;
        }
        output.putUInt(typeCode);
        if (!this.hasWrittenSrid) {
            int srid = geometry.getSRID();
            output.putInt(Math.max(srid, 0));
            this.hasWrittenSrid = true;
        }
    }

    protected int geometryTypeCode(Geometry<P> geometry) {
        if (geometry.isEmpty() && geometry.getGeometryType() == GeometryType.POINT) {
            return WkbGeometryType.MULTI_POINT.getTypeCode();
        }
        WkbGeometryType type = WkbGeometryType.forClass(geometry.getClass());
        if (type == null) {
            throw new UnsupportedConversionException(String.format("Can't convert geometries of type %s", geometry.getClass().getCanonicalName()));
        }
        return type.getTypeCode();
    }
}

