/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import org.mapstruct.ap.internal.gem.BuilderGem;
import org.mapstruct.ap.internal.model.AbstractBaseBuilder;
import org.mapstruct.ap.internal.model.ForgedMethod;
import org.mapstruct.ap.internal.model.ForgedMethodHistory;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.beanmapping.MappingReferences;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.util.Strings;

public abstract class AbstractMappingMethodBuilder<B extends AbstractMappingMethodBuilder<B, M>, M extends MappingMethod>
extends AbstractBaseBuilder<B> {
    private ForgedMethodHistory description;

    public AbstractMappingMethodBuilder(Class<B> selfType) {
        super(selfType);
    }

    public abstract M build();

    protected abstract boolean shouldUsePropertyNamesInHistory();

    Assignment forgeMapping(SourceRHS sourceRHS, Type sourceType, Type targetType) {
        return this.forgeMapping(sourceRHS, sourceType, targetType, ForgedMethod::forElementMapping);
    }

    Assignment forgeSubclassMapping(SourceRHS sourceRHS, Type sourceType, Type targetType, MappingReferences mappingReferences) {
        return this.forgeMapping(sourceRHS, sourceType, targetType, ForgeMethodCreator.forSubclassMapping(mappingReferences));
    }

    private Assignment forgeMapping(SourceRHS sourceRHS, Type sourceType, Type targetType, ForgeMethodCreator forgeMethodCreator) {
        if (!this.canGenerateAutoSubMappingBetween(sourceType, targetType)) {
            return null;
        }
        String name = this.getName(sourceType, targetType);
        name = Strings.getSafeVariableName(name, this.ctx.getReservedNames());
        ForgedMethodHistory history = null;
        if (this.method instanceof ForgedMethod) {
            history = ((ForgedMethod)this.method).getHistory();
        }
        this.description = new ForgedMethodHistory(history, Strings.stubPropertyName(sourceRHS.getSourceType().getName()), Strings.stubPropertyName(targetType.getName()), sourceRHS.getSourceType(), targetType, this.shouldUsePropertyNamesInHistory(), sourceRHS.getSourceErrorMessagePart());
        ForgedMethod forgedMethod = forgeMethodCreator.createMethod(name, sourceType, targetType, this.method, this.description, true);
        BuilderGem builder = this.method.getOptions().getBeanMapping().getBuilder();
        return this.createForgedAssignment(sourceRHS, this.ctx.getTypeFactory().builderTypeFor(targetType, builder), forgedMethod);
    }

    private String getName(Type sourceType, Type targetType) {
        String fromName = this.getName(sourceType);
        String toName = this.getName(targetType);
        return Strings.decapitalize(fromName + "To" + toName);
    }

    private String getName(Type type) {
        StringBuilder builder = new StringBuilder();
        for (Type typeParam : type.getTypeParameters()) {
            builder.append(typeParam.getIdentification());
        }
        builder.append(type.getIdentification());
        return builder.toString();
    }

    public ForgedMethodHistory getDescription() {
        return this.description;
    }

    private static interface ForgeMethodCreator {
        public ForgedMethod createMethod(String var1, Type var2, Type var3, Method var4, ForgedMethodHistory var5, boolean var6);

        public static ForgeMethodCreator forSubclassMapping(MappingReferences mappingReferences) {
            return (name, sourceType, targetType, method, description, forgedNameBased) -> ForgedMethod.forSubclassMapping(name, sourceType, targetType, method, mappingReferences, description, forgedNameBased);
        }
    }
}

